let lightbox = GLightbox({
    selector: '.glightbox',
    touchNavigation: true,
    loop: true,
    zoomable: true
});

// --- 作品表示 ---
window.displayWorks = function (filter, btnElement) {
    const items = document.querySelectorAll('.work-item');
    const buttons = document.querySelectorAll('.category-btn');

    buttons.forEach(btn => btn.classList.remove('active'));
    if (btnElement) btnElement.classList.add('active');

    items.forEach(item => {
        const category = item.getAttribute('data-category');

        if (filter === 'All' || category === filter) {
            item.style.display = 'block';
            setTimeout(() => {
                item.classList.add('show');
            }, 20);
        } else {
            item.classList.remove('show');
            item.style.display = 'none';
        }
    });

    setTimeout(() => {
    if (lightbox) {
        lightbox.destroy();
    }
    lightbox = GLightbox({
        selector: '.work-item[style*="display: block"] .glightbox',
        touchNavigation: true,
        loop: true,
        zoomable: true
    });
}, 500);

};

// カテゴリーボタン
const initialBtn = document.querySelector('.category-btn.active');
displayWorks('All', initialBtn);

document.body.classList.remove('is-hide');