document.addEventListener('DOMContentLoaded', () => {
    if (typeof COMIC_LIST === 'undefined') return;

    const mainElement = document.querySelector('main');
    if (!mainElement) return;

    mainElement.innerHTML = COMIC_LIST.map(comic => `
        <section class="fade-in" style="margin-bottom: 80px;">
            <div class="comic-info-wrap">
                <img src="${comic.cover}" alt="${comic.title}" class="comic-cover">

                <div class="comin-info fade-in">
                    <h2>${comic.title}</h2>
                    <p>${comic.description}</p>
                    <div class="button-container">
                        <a href="${comic.latestEpisode}" class="custom-link-btn fade-in">最新話を読む</a>
                        <a href="${comic.firstEpisode}" class="custom-link-btn fade-in">初めから読む</a>
                    </div>
                </div>
            </div>

            <div class="comic-story">
                ${comic.episodes.map(ep => `
                    <div class="comic-item fade-in">
                        <a href="${ep.url}">
                            <img src="${ep.thumb}" alt="${ep.title}">
                        </a>
                        <h3>${ep.title}</h3>
                    </div>
                `).join('')}
            </div>
        </section>
    `).join('');

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('is-visible');
            }
        });
    }, { threshold: 0.1 });

    document.querySelectorAll('.fade-in').forEach(item => observer.observe(item));
});