document.addEventListener('DOMContentLoaded', () => {
    if (typeof SITE_CONFIG === 'undefined') return;

    // --- お知らせ ---
    const newsList = document.querySelector('.news-list ul');
    if (newsList && SITE_CONFIG.news) {
        newsList.innerHTML = SITE_CONFIG.news.map(n => `
            <li class="fade-in"><span class="news-date">${n.date}</span>${n.text}</li>
        `).join('');
    }

    // --- SNSアイコン ---
    const snsList = document.querySelector('.sns-icon');
    if (snsList && SITE_CONFIG.sns) {
        snsList.innerHTML = SITE_CONFIG.sns.map(s => `
            <li><a href="${s.url}"><i class="fa-brands ${s.icon}"></i></a></li>
        `).join('');
    }

    // --- カスタムリンクボタン ---
    const btnContainer = document.querySelector('.button-container') || document.getElementById('custom-buttons');
    if (btnContainer && SITE_CONFIG.buttons) {
        btnContainer.innerHTML = SITE_CONFIG.buttons.map(b => `
            <a href="${b.url}" class="custom-link-btn fade-in">${b.label}</a>
        `).join('');
    }

    // --- テキスト・プロフィール ---
    if (document.querySelector('.header-text')) document.querySelector('.header-text').innerHTML = SITE_CONFIG.headerText;
    if (document.querySelector('.about-text')) document.querySelector('.about-text').innerHTML = SITE_CONFIG.profileText;
    if (document.querySelector('.about-name')) document.querySelector('.about-name').innerText = SITE_CONFIG.adminName;

    // --- トピック ---
    if (SITE_CONFIG.topic && document.querySelector('.topic-wrap')) {
        const wrap = document.querySelector('.topic-wrap');
        wrap.querySelector('a').href = SITE_CONFIG.topic.url;
        wrap.querySelector('.topic-img').src = SITE_CONFIG.topic.img;
        wrap.querySelector('.topic-title').innerText = SITE_CONFIG.topic.title;
    }

    // --- リンク集 (LINK_DATA) ---
    if (typeof LINK_DATA !== 'undefined') {

        const createLinkContent = (link) => {
            if (link.img && link.img !== "") {
                return `<img src="${link.img}" alt="${link.name}" class="banner">`;
            }
            return `<span>${link.name}</span>`;
        };

        const targets = [
            { selector: '.favorite .link-img', data: LINK_DATA.favorite },
            { selector: '.thanks:nth-of-type(2) .link-text', data: LINK_DATA.search },
            { selector: '.thanks:nth-of-type(3) .link-text', data: LINK_DATA.thanks }
        ];

        targets.forEach(target => {
            const listElement = document.querySelector(target.selector);
            if (listElement && target.data) {
                listElement.innerHTML = target.data.map(link => `
                <li>
                    <a href="${link.url}" target="_blank">
                        ${createLinkContent(link)}
                    </a>
                </li>
            `).join('');
            }
        });
    }

    // --- フェードイン ---
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) entry.target.classList.add('is-visible');
        });
    }, { threshold: 0.1 });

    document.querySelectorAll('.fade-in').forEach(item => observer.observe(item));
});