document.addEventListener('DOMContentLoaded', () => {
    if (typeof SITE_CONFIG === 'undefined') return;

    // --- 階層判定 ---
    const isSubPage = document.querySelector('.illustration-page, .comic-page') !== null;
    const pathPrefix = isSubPage ? '../' : '';

    // --- ファビコン ---
    const favLink = document.getElementById('favicon-link');
    if (favLink && SITE_CONFIG.favicon) {
        favLink.href = pathPrefix + SITE_CONFIG.favicon;
    }

    // --- サイト名 ---
    document.title = SITE_CONFIG.title;
    document.querySelectorAll('.site-info h1, footer p:first-child, .site-title').forEach(el => {
        el.innerText = SITE_CONFIG.title;
    });

    // --- フッターバナー ---
    const footerBannerImg = document.querySelector('footer .banner');
    if (footerBannerImg && SITE_CONFIG.footerBanner) {
        if (SITE_CONFIG.footerBanner.img) {
            footerBannerImg.src = pathPrefix + SITE_CONFIG.footerBanner.img;
        } else {
            footerBannerImg.style.display = 'none';
        }
    }

    // --- URL表示 ---
    const currentUrl = window.location.href;
    document.querySelectorAll('.url-display').forEach(el => el.textContent = currentUrl);
});