document.addEventListener('DOMContentLoaded', () => {
    // --- 1. SITE_CONFIGの内容をHTMLに反映 ---
    document.querySelectorAll('.site-title').forEach(el => el.textContent = SITE_CONFIG.title);
    document.title = SITE_CONFIG.title;

    const profileNameEl = document.querySelector('.profile-name');
    if (profileNameEl) profileNameEl.textContent = SITE_CONFIG.adminName;

    const profileTextEl = document.querySelector('.profile-text');
    if (profileTextEl) profileTextEl.innerHTML = SITE_CONFIG.profileText;

    const buttonContainer = document.getElementById('custom-buttons');
    if (buttonContainer && SITE_CONFIG.links) {
        buttonContainer.innerHTML = SITE_CONFIG.links.map(link =>
            `<a href="${link.url}" class="custom-link-btn" target="_blank" rel="noopener noreferrer">${link.label}</a>`
        ).join('');
    }

    // --- カテゴリーボタンと作品を生成---
    const categoryFilter = document.getElementById('category-filter');
    if (categoryFilter && SITE_CONFIG.works) {
        const categories = [...new Set(SITE_CONFIG.works.map(w => w.category))];
        let buttonsHtml = `<button class="category-btn active" onclick="displayWorks('All', this)">All</button>`;
        categories.forEach(cat => {
            buttonsHtml += `<button class="category-btn" onclick="displayWorks('${cat}', this)">${cat}</button>`;
        });
        categoryFilter.innerHTML = buttonsHtml;
    }

    const gridContainer = document.querySelector('.grid-container');
    if (gridContainer && SITE_CONFIG.works) {
        gridContainer.innerHTML = SITE_CONFIG.works.map(work => `
        <div class="work-item" data-category="${work.category}">
            <a href="${work.movie || work.img}" class="glightbox" data-type="${work.type || 'image'}"
                data-title="${work.title}"
                data-description="${work.caption || ''}">
                <img src="${work.img}" class="works-item-thumbnail" alt="${work.title}">
            </a>
        </div>
    `).join('');
    }

    const initialBtn = document.querySelector('.category-btn.active');

    // GLightboxの初期化
    let lightbox = GLightbox({
        selector: '.glightbox',
        touchNavigation: true,
        loop: true,
        zoomable: true,
        videosWidth: '960px',
        youtube: {
            params: {
                rel: 0,
                showinfo: 0,
                allowfullscren: 1
            }
        }
    });

    window.displayWorks = function (filter, btnElement) {
        const items = document.querySelectorAll('.work-item');
        const buttons = document.querySelectorAll('.category-btn');

        buttons.forEach(btn => btn.classList.remove('active'));
        if (btnElement) btnElement.classList.add('active');

        items.forEach(item => {
            const category = item.getAttribute('data-category');
            if (filter === 'All' || category === filter) {
                item.style.display = 'block';
                setTimeout(() => item.classList.add('show'), 20);
            } else {
                item.classList.remove('show');
                item.style.display = 'none';
            }
        });

        setTimeout(() => {
            if (lightbox) lightbox.destroy();
            lightbox = GLightbox({
                selector: '.work-item[style*="display: block"] .glightbox',
                touchNavigation: true,
                loop: true,
                zoomable: true
            });
        }, 500);
    };

    displayWorks('All', initialBtn);

    // --- アニメーション ---
    const fadeInItems = document.querySelectorAll('.fade-in');
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) entry.target.classList.add('is-visible');
        });
    }, { threshold: 0.1 });

    fadeInItems.forEach(item => observer.observe(item));

    document.body.classList.remove('is-hide');
});